import { registerBlockType } from '@wordpress/blocks';
import { Edit } from './edit';
import metadata from './block.json';
import { Save } from './save';

function Icon() {
	return (
		<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" className="gblocks-block-icon" aria-hidden="true" focusable="false">
			<path d="M21.374,6.133L14.67,6.133C14.327,6.133 14.045,5.851 14.045,5.508C14.045,5.165 14.327,4.883 14.67,4.883L21.374,4.883C21.717,4.883 21.999,5.165 21.999,5.508C21.999,5.851 21.717,6.133 21.374,6.133ZM21.374,9.015L14.67,9.015C14.327,9.015 14.045,8.733 14.045,8.39C14.045,8.047 14.327,7.765 14.67,7.765L21.374,7.765C21.717,7.765 21.999,8.047 21.999,8.39C21.999,8.733 21.717,9.015 21.374,9.015ZM21.374,3.251L14.67,3.251C14.327,3.251 14.044,2.969 14.044,2.626C14.044,2.282 14.327,2 14.67,2L21.374,2C21.717,2 21.999,2.282 21.999,2.626C21.999,2.969 21.717,3.251 21.374,3.251ZM9.329,19.118L2.625,19.118C2.282,19.118 2,18.836 2,18.493C2,18.15 2.282,17.868 2.625,17.868L9.329,17.868C9.672,17.868 9.954,18.15 9.954,18.493C9.954,18.836 9.672,19.118 9.329,19.118ZM9.329,22.001L2.625,22.001C2.282,22.001 2,21.719 2,21.376C2,21.033 2.282,20.751 2.625,20.751L9.329,20.751C9.672,20.751 9.954,21.033 9.954,21.376C9.954,21.719 9.672,22.001 9.329,22.001ZM9.329,16.235L2.625,16.235C2.282,16.235 2,15.953 2,15.61C2,15.267 2.282,14.985 2.625,14.985L9.329,14.985C9.672,14.985 9.954,15.267 9.954,15.61C9.954,15.953 9.672,16.235 9.329,16.235Z" style={ { fillOpacity: 0.3, fillRule: 'nonzero' } } />
			<path d="M16.841,22.001C15.468,22.002 14.15,21.455 13.18,20.484C11.219,18.523 11.304,15.194 11.387,11.974C11.482,8.269 11.572,4.77 8.741,3.575C7.466,3.037 6.01,3.17 4.941,3.926C3.96,4.618 3.365,5.647 3.264,6.821C3.165,7.976 3.581,9.118 4.401,9.937C5.283,10.819 6.646,11.259 8.82,11.365C9.164,11.382 9.43,11.675 9.414,12.02C9.4,12.351 9.124,12.615 8.794,12.615C8.782,12.615 8.771,12.615 8.759,12.614C7.071,12.532 4.949,12.254 3.517,10.822C2.437,9.742 1.888,8.237 2.019,6.715C2.154,5.183 2.96,3.786 4.22,2.904C5.638,1.902 7.557,1.718 9.226,2.423C12.842,3.949 12.737,8.045 12.635,12.006C12.559,14.962 12.481,18.018 14.063,19.6C14.882,20.42 16.023,20.837 17.177,20.737C18.351,20.637 19.379,20.042 20.073,19.062C20.827,17.996 20.962,16.542 20.426,15.266C19.706,13.55 18.143,12.757 15.2,12.614C14.858,12.597 14.59,12.301 14.606,11.959C14.617,11.629 14.891,11.364 15.221,11.364C15.234,11.364 15.248,11.364 15.261,11.365C17.581,11.477 20.397,11.967 21.578,14.781C22.279,16.451 22.093,18.368 21.092,19.783C20.121,21.169 18.533,21.997 16.841,22.001Z" style={ { fillRule: 'nonzero' } } />
		</svg>
	);
}

registerBlockType( metadata, {
	edit: Edit,
	save: Save,
	icon: Icon,
} );
